<?php //ad8f0be06ecfa6ae30890a030300bd87
/** @noinspection all */

namespace Modules\CountryManage\Entities {

    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_City_C;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_City_QB;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_Country_C;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_Country_QB;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_State_C;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_State_QB;
    use LaravelIdea\Helper\Modules\TaxModule\Entities\_IH_CountryTax_QB;
    use LaravelIdea\Helper\Modules\TaxModule\Entities\_IH_StateTax_QB;
    use Modules\TaxModule\Entities\CountryTax;
    use Modules\TaxModule\Entities\StateTax;
    
    /**
     * @property int $id
     * @property string $name
     * @property int $country_id
     * @property int $state_id
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Carbon|null $deleted_at
     * @property Country $country
     * @method BelongsTo|_IH_Country_QB country()
     * @property State $state
     * @method BelongsTo|_IH_State_QB state()
     * @method static _IH_City_QB onWriteConnection()
     * @method _IH_City_QB newQuery()
     * @method static _IH_City_QB on(null|string $connection = null)
     * @method static _IH_City_QB query()
     * @method static _IH_City_QB with(array|string $relations)
     * @method _IH_City_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_City_C|City[] all()
     * @ownLinks country_id,\Modules\CountryManage\Entities\Country,id|state_id,\Modules\CountryManage\Entities\State,id
     * @foreignLinks id,\Modules\TaxModule\Entities\TaxClassOption,city_id
     * @mixin _IH_City_QB
     */
    class City extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property CountryTax $countryTax
     * @method HasOne|_IH_CountryTax_QB countryTax()
     * @property _IH_State_C|State[] $states
     * @property-read int $states_count
     * @method HasMany|_IH_State_QB states()
     * @method static _IH_Country_QB onWriteConnection()
     * @method _IH_Country_QB newQuery()
     * @method static _IH_Country_QB on(null|string $connection = null)
     * @method static _IH_Country_QB query()
     * @method static _IH_Country_QB with(array|string $relations)
     * @method _IH_Country_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Country_C|Country[] all()
     * @foreignLinks id,\Modules\CountryManage\Entities\City,country_id|id,\App\Models\UserDeliveryAddress,country_id|id,\Modules\TaxModule\Entities\TaxClassOption,country_id|id,\Modules\CountryManage\Entities\State,country_id|id,\Modules\TaxModule\Entities\CountryTax,country_id|id,\Modules\TaxModule\Entities\StateTax,country_id|id,\Modules\ShippingModule\Entities\ShippingAddress,country_id
     * @mixin _IH_Country_QB
     */
    class Country extends Model {}
    
    /**
     * @property int $id
     * @property string $name
     * @property int $country_id
     * @property string $status
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Country $country
     * @method BelongsTo|_IH_Country_QB country()
     * @property StateTax $stateTax
     * @method HasOne|_IH_StateTax_QB stateTax()
     * @method static _IH_State_QB onWriteConnection()
     * @method _IH_State_QB newQuery()
     * @method static _IH_State_QB on(null|string $connection = null)
     * @method static _IH_State_QB query()
     * @method static _IH_State_QB with(array|string $relations)
     * @method _IH_State_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_State_C|State[] all()
     * @ownLinks country_id,\Modules\CountryManage\Entities\Country,id
     * @foreignLinks id,\Modules\CountryManage\Entities\City,state_id|id,\App\Models\UserDeliveryAddress,state_id|id,\Modules\TaxModule\Entities\TaxClassOption,state_id|id,\Modules\TaxModule\Entities\StateTax,state_id|id,\Modules\ShippingModule\Entities\ShippingAddress,state_id
     * @mixin _IH_State_QB
     */
    class State extends Model {}
}