<?php //ee8da0d2b3de1c97b46c4289c55aae11
/** @noinspection all */

namespace Modules\RefundModule\Entities {

    use App\Models\Admin;
    use App\Models\ProductOrder;
    use App\Models\User;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_Admin_QB;
    use LaravelIdea\Helper\App\Models\_IH_ProductOrder_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\Modules\Product\Entities\_IH_Product_QB;
    use LaravelIdea\Helper\Modules\RefundModule\Entities\_IH_RefundChatMessage_C;
    use LaravelIdea\Helper\Modules\RefundModule\Entities\_IH_RefundChatMessage_QB;
    use LaravelIdea\Helper\Modules\RefundModule\Entities\_IH_RefundChat_C;
    use LaravelIdea\Helper\Modules\RefundModule\Entities\_IH_RefundChat_QB;
    use LaravelIdea\Helper\Modules\RefundModule\Entities\_IH_RefundProduct_C;
    use LaravelIdea\Helper\Modules\RefundModule\Entities\_IH_RefundProduct_QB;
    use Modules\Product\Entities\Product;

    /**
     * @property int $id
     * @property string|null $title
     * @property string|null $via
     * @property string|null $operating_system
     * @property string|null $user_agent
     * @property string|null $description
     * @property string|null $subject
     * @property string|null $status
     * @property int|null $user_id
     * @property int|null $admin_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Admin|null $admin
     * @method BelongsTo|_IH_Admin_QB admin()
     * @property User|null $user
     * @method BelongsTo|_IH_User_QB user()
     * @method static _IH_RefundChat_QB onWriteConnection()
     * @method _IH_RefundChat_QB newQuery()
     * @method static _IH_RefundChat_QB on(null|string $connection = null)
     * @method static _IH_RefundChat_QB query()
     * @method static _IH_RefundChat_QB with(array|string $relations)
     * @method _IH_RefundChat_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RefundChat_C|RefundChat[] all()
     * @ownLinks user_id,\App\Models\User,id|admin_id,\App\Models\Admin,id
     * @mixin _IH_RefundChat_QB
     */
    class RefundChat extends Model {}

    /**
     * @property int $id
     * @property string|null $message
     * @property string|null $notify
     * @property string|null $attachment
     * @property string|null $type
     * @property int|null $user_id
     * @property int|null $refund_chat_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_RefundChatMessage_QB onWriteConnection()
     * @method _IH_RefundChatMessage_QB newQuery()
     * @method static _IH_RefundChatMessage_QB on(null|string $connection = null)
     * @method static _IH_RefundChatMessage_QB query()
     * @method static _IH_RefundChatMessage_QB with(array|string $relations)
     * @method _IH_RefundChatMessage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RefundChatMessage_C|RefundChatMessage[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_RefundChatMessage_QB
     */
    class RefundChatMessage extends Model {}

    /**
     * @property int $id
     * @property int $user_id
     * @property int $order_id
     * @property int $product_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property bool|null $status
     * @property ProductOrder $order
     * @method HasOne|_IH_ProductOrder_QB order()
     * @property Product $product
     * @method HasOne|_IH_Product_QB product()
     * @property User $user
     * @method HasOne|_IH_User_QB user()
     * @method static _IH_RefundProduct_QB onWriteConnection()
     * @method _IH_RefundProduct_QB newQuery()
     * @method static _IH_RefundProduct_QB on(null|string $connection = null)
     * @method static _IH_RefundProduct_QB query()
     * @method static _IH_RefundProduct_QB with(array|string $relations)
     * @method _IH_RefundProduct_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_RefundProduct_C|RefundProduct[] all()
     * @ownLinks user_id,\App\Models\User,id|order_id,\App\Models\Order,id|product_id,\Modules\Product\Entities\Product,id
     * @mixin _IH_RefundProduct_QB
     */
    class RefundProduct extends Model {}
}
