<?php //834fdf19f3e78d2cab8b58a7f5aad3b3
/** @noinspection all */

namespace Modules\ShippingModule\Entities {

    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_Country_QB;
    use LaravelIdea\Helper\Modules\CountryManage\Entities\_IH_State_QB;
    use LaravelIdea\Helper\Modules\ShippingModule\Entities\_IH_ShippingAddress_C;
    use LaravelIdea\Helper\Modules\ShippingModule\Entities\_IH_ShippingAddress_QB;
    use LaravelIdea\Helper\Modules\ShippingModule\Entities\_IH_ShippingMethodOption_C;
    use LaravelIdea\Helper\Modules\ShippingModule\Entities\_IH_ShippingMethodOption_QB;
    use LaravelIdea\Helper\Modules\ShippingModule\Entities\_IH_ShippingMethod_C;
    use LaravelIdea\Helper\Modules\ShippingModule\Entities\_IH_ShippingMethod_QB;
    use LaravelIdea\Helper\Modules\ShippingModule\Entities\_IH_UserShippingAddress_C;
    use LaravelIdea\Helper\Modules\ShippingModule\Entities\_IH_UserShippingAddress_QB;
    use LaravelIdea\Helper\Modules\ShippingModule\Entities\_IH_ZoneRegion_C;
    use LaravelIdea\Helper\Modules\ShippingModule\Entities\_IH_ZoneRegion_QB;
    use LaravelIdea\Helper\Modules\ShippingModule\Entities\_IH_Zone_C;
    use LaravelIdea\Helper\Modules\ShippingModule\Entities\_IH_Zone_QB;
    use Modules\CountryManage\Entities\Country;
    use Modules\CountryManage\Entities\State;

    /**
     * @property int $id
     * @property string $name
     * @property string|null $email
     * @property string|null $phone
     * @property int|null $user_id
     * @property int|null $country_id
     * @property int|null $state_id
     * @property string|null $city
     * @property string|null $zip_code
     * @property string|null $address
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Country|null $country
     * @method BelongsTo|_IH_Country_QB country()
     * @property State|null $state
     * @method BelongsTo|_IH_State_QB state()
     * @method static _IH_ShippingAddress_QB onWriteConnection()
     * @method _IH_ShippingAddress_QB newQuery()
     * @method static _IH_ShippingAddress_QB on(null|string $connection = null)
     * @method static _IH_ShippingAddress_QB query()
     * @method static _IH_ShippingAddress_QB with(array|string $relations)
     * @method _IH_ShippingAddress_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ShippingAddress_C|ShippingAddress[] all()
     * @ownLinks user_id,\App\Models\User,id|country_id,\Modules\CountryManage\Entities\Country,id|state_id,\Modules\CountryManage\Entities\State,id
     * @foreignLinks id,\App\Models\ProductOrder,shipping_address_id
     * @mixin _IH_ShippingAddress_QB
     */
    class ShippingAddress extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property int|null $zone_id
     * @property bool $is_default
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property ShippingMethodOption $availableOptions
     * @method HasOne|_IH_ShippingMethodOption_QB availableOptions()
     * @property ShippingMethodOption $options
     * @method HasOne|_IH_ShippingMethodOption_QB options()
     * @property Zone|null $zone
     * @method BelongsTo|_IH_Zone_QB zone()
     * @method static _IH_ShippingMethod_QB onWriteConnection()
     * @method _IH_ShippingMethod_QB newQuery()
     * @method static _IH_ShippingMethod_QB on(null|string $connection = null)
     * @method static _IH_ShippingMethod_QB query()
     * @method static _IH_ShippingMethod_QB with(array|string $relations)
     * @method _IH_ShippingMethod_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ShippingMethod_C|ShippingMethod[] all()
     * @ownLinks zone_id,\Modules\ShippingModule\Entities\Zone,id
     * @foreignLinks id,\Modules\ShippingModule\Entities\ShippingMethodOption,shipping_method_id
     * @mixin _IH_ShippingMethod_QB
     */
    class ShippingMethod extends Model {}

    /**
     * @property int $id
     * @property string $title
     * @property int $shipping_method_id
     * @property bool $status
     * @property bool $tax_status
     * @property string|null $setting_preset
     * @property float $cost
     * @property float|null $minimum_order_amount
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $coupon
     * @method static _IH_ShippingMethodOption_QB onWriteConnection()
     * @method _IH_ShippingMethodOption_QB newQuery()
     * @method static _IH_ShippingMethodOption_QB on(null|string $connection = null)
     * @method static _IH_ShippingMethodOption_QB query()
     * @method static _IH_ShippingMethodOption_QB with(array|string $relations)
     * @method _IH_ShippingMethodOption_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ShippingMethodOption_C|ShippingMethodOption[] all()
     * @ownLinks shipping_method_id,\Modules\ShippingModule\Entities\ShippingMethod,id
     * @mixin _IH_ShippingMethodOption_QB
     */
    class ShippingMethodOption extends Model {}

    /**
     * @property int $id
     * @property int $user_id
     * @property string $name
     * @property string $address
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_UserShippingAddress_QB onWriteConnection()
     * @method _IH_UserShippingAddress_QB newQuery()
     * @method static _IH_UserShippingAddress_QB on(null|string $connection = null)
     * @method static _IH_UserShippingAddress_QB query()
     * @method static _IH_UserShippingAddress_QB with(array|string $relations)
     * @method _IH_UserShippingAddress_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_UserShippingAddress_C|UserShippingAddress[] all()
     * @ownLinks user_id,\App\Models\User,id
     * @mixin _IH_UserShippingAddress_QB
     */
    class UserShippingAddress extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property ZoneRegion $region
     * @method HasOne|_IH_ZoneRegion_QB region()
     * @method static _IH_Zone_QB onWriteConnection()
     * @method _IH_Zone_QB newQuery()
     * @method static _IH_Zone_QB on(null|string $connection = null)
     * @method static _IH_Zone_QB query()
     * @method static _IH_Zone_QB with(array|string $relations)
     * @method _IH_Zone_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Zone_C|Zone[] all()
     * @foreignLinks id,\Modules\ShippingModule\Entities\ShippingMethod,zone_id|id,\Modules\ShippingModule\Entities\ZoneRegion,zone_id
     * @mixin _IH_Zone_QB
     */
    class Zone extends Model {}

    /**
     * @property int $id
     * @property int $zone_id
     * @property string|null $country
     * @property string|null $state
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ZoneRegion_QB onWriteConnection()
     * @method _IH_ZoneRegion_QB newQuery()
     * @method static _IH_ZoneRegion_QB on(null|string $connection = null)
     * @method static _IH_ZoneRegion_QB query()
     * @method static _IH_ZoneRegion_QB with(array|string $relations)
     * @method _IH_ZoneRegion_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ZoneRegion_C|ZoneRegion[] all()
     * @ownLinks zone_id,\Modules\ShippingModule\Entities\Zone,id
     * @mixin _IH_ZoneRegion_QB
     */
    class ZoneRegion extends Model {}
}
