<?php

namespace Plugins\WidgetBuilder\Widgets;


use App\Facades\GlobalLanguage;
use App\Helpers\LanguageHelper;
use App\Models\Language;
use App\Models\Widgets;
use Modules\Blog\Entities\BlogCategory;
use Plugins\PageBuilder\Fields\Image;
use Plugins\PageBuilder\Fields\Number;
use Plugins\PageBuilder\Fields\Repeater;
use Plugins\PageBuilder\Fields\Select;
use Plugins\PageBuilder\Fields\Text;
use Plugins\PageBuilder\Fields\Textarea;
use Plugins\PageBuilder\Helpers\RepeaterField;
use Plugins\WidgetBuilder\WidgetBase;
use Mews\Purifier\Facades\Purifier;
use App\Helpers\SanitizeInput;

class AboutUsWidgetTwo extends WidgetBase
{
    public function admin_render()
    {
        $output = $this->admin_form_before();
        $output .= $this->admin_form_start();
        $output .= $this->default_fields();

        $widget_saved_values = $this->get_settings();

        $output .= Image::get([
            'name' => 'logo_image',
            'label' => __('Logo'),
            'value' => $widget_saved_values['logo_image'] ?? null
        ]);

        //repeater
        $output .= Repeater::get([
            'settings' => $widget_saved_values,
            'id' => 'footer_repeater',
            'fields' => [
                [
                    'type' => RepeaterField::TEXT,
                    'name' => 'repeater_text',
                    'label' => __('Text')
                ],

                [
                    'type' => RepeaterField::TEXT,
                    'name' => 'repeater_text_url',
                    'label' => __('Text URL')
                ],
            ]
        ]);

        $output .= $this->admin_form_submit_button();
        $output .= $this->admin_form_end();
        $output .= $this->admin_form_after();

        return $output;
    }


    public function enable(): bool
    {
        return is_null(tenant()); // TODO: Change the autogenerated stub
    }

    public function frontend_render()
    {
        $widget_saved_values = $this->get_settings();
        $site_url = url('/');
        $logo = render_image_markup_by_attachment_id($widget_saved_values['logo_image']) ?? null;

        $repeater_data = $widget_saved_values['footer_repeater'] ?? [];

        $repeater_markup = '';
        foreach ($repeater_data['repeater_text_'] as $key => $url) {
            $text = SanitizeInput::esc_html($repeater_data['repeater_text_'][$key]) ?? '';
            $text_url = SanitizeInput::esc_url($repeater_data['repeater_text_url_'][$key]) ?? '#';

            $repeater_markup .= '<a href="'.$text_url.'" class="contact-item"> '.$text.' </a>';
        }

        return '<div class="col-lg-3 col-md-6 col-sm-6 mt-4">
                        <div class="footer-widget widget ">
                            <div class="about_us_widget">
                                <a href="'.$site_url.'" class="footer-logo">
                                    '.$logo.'
                                </a>
                            </div>
                            <div class="footer-inner mt-4">
                                <div class="footer-contact">
                                    '.$repeater_markup.'
                                </div>
                            </div>
                        </div>
                    </div>';
    }

    public function widget_title()
    {
        return __('Theme 2: About Us(02)');
    }

}
